class mx.containers.ScrollPane extends mx.core.ScrollView
{
    var _total, _loaded, destroyChildAt, createChild, __scrollContent, __get__contentPath, spContentHolder, hScroller, vScroller, __get__vLineScrollSize, __get__hLineScrollSize, __get__vPageScrollSize, __get__hPageScrollSize, __get__hScrollPolicy, __vScrollPolicy, __get__vScrollPolicy, _parent, onMouseMove, __get__scrollDrag, tabEnabled, keyDown, mask_mc, __set__contentPath, __get__maxHPosition, hPosition, __get__maxVPosition, vPosition, __hPosition, __vPosition, __set__scrollDrag, invalidate, lastX, _xmouse, lastY, _ymouse, _width, _height, _x, _y, __get__content, __set__hLineScrollSize, __set__hPageScrollSize, __set__hScrollPolicy, __set__vLineScrollSize, __set__vPageScrollSize, __set__vScrollPolicy;
    function ScrollPane()
    {
        super();
    } // End of the function
    function getBytesTotal()
    {
        return (_total);
    } // End of the function
    function getBytesLoaded()
    {
        return (_loaded);
    } // End of the function
    function set contentPath(scrollableContent)
    {
        if (!initializing)
        {
            if (scrollableContent == undefined)
            {
                this.destroyChildAt(0);
            }
            else
            {
                if (this[mx.core.View.childNameBase + 0] != undefined)
                {
                    this.destroyChildAt(0);
                } // end if
                this.createChild(scrollableContent, "spContentHolder");
            } // end if
        } // end else if
        __scrollContent = scrollableContent;
        //return (this.contentPath());
        null;
    } // End of the function
    function get contentPath()
    {
        return (__scrollContent);
    } // End of the function
    function get content()
    {
        return (spContentHolder);
    } // End of the function
    function setHPosition(position)
    {
        if (position <= hScroller.maxPos && position >= hScroller.minPos)
        {
            super.setHPosition(position);
            spContentHolder._x = -position;
        } // end if
    } // End of the function
    function setVPosition(position)
    {
        if (position <= vScroller.maxPos && position >= vScroller.minPos)
        {
            super.setVPosition(position);
            spContentHolder._y = -position;
        } // end if
    } // End of the function
    function get vLineScrollSize()
    {
        return (__vLineScrollSize);
    } // End of the function
    function set vLineScrollSize(vLineSize)
    {
        __vLineScrollSize = vLineSize;
        vScroller.__set__lineScrollSize(vLineSize);
        //return (this.vLineScrollSize());
        null;
    } // End of the function
    function get hLineScrollSize()
    {
        return (__hLineScrollSize);
    } // End of the function
    function set hLineScrollSize(hLineSize)
    {
        __hLineScrollSize = hLineSize;
        hScroller.__set__lineScrollSize(hLineSize);
        //return (this.hLineScrollSize());
        null;
    } // End of the function
    function get vPageScrollSize()
    {
        return (__vPageScrollSize);
    } // End of the function
    function set vPageScrollSize(vPageSize)
    {
        __vPageScrollSize = vPageSize;
        vScroller.__set__pageScrollSize(vPageSize);
        //return (this.vPageScrollSize());
        null;
    } // End of the function
    function get hPageScrollSize()
    {
        return (__hPageScrollSize);
    } // End of the function
    function set hPageScrollSize(hPageSize)
    {
        __hPageScrollSize = hPageSize;
        hScroller.__set__pageScrollSize(hPageSize);
        //return (this.hPageScrollSize());
        null;
    } // End of the function
    function set hScrollPolicy(policy)
    {
        __hScrollPolicy = policy.toLowerCase();
        this.setScrollProperties(spContentHolder._width, 1, spContentHolder._height, 1);
        //return (this.hScrollPolicy());
        null;
    } // End of the function
    function set vScrollPolicy(policy)
    {
        __vScrollPolicy = policy.toLowerCase();
        this.setScrollProperties(spContentHolder._width, 1, spContentHolder._height, 1);
        //return (this.vScrollPolicy());
        null;
    } // End of the function
    function get scrollDrag()
    {
        return (__scrollDrag);
    } // End of the function
    function set scrollDrag(s)
    {
        __scrollDrag = s;
        if (__scrollDrag)
        {
            spContentHolder.useHandCursor = true;
            spContentHolder.onPress = function ()
            {
                _parent.startDragLoop();
            };
            spContentHolder.tabEnabled = false;
            spContentHolder.onRelease = spContentHolder.onReleaseOutside = function ()
            {
                delete this.onMouseMove;
            };
            __scrollDrag = true;
        }
        else
        {
            delete spContentHolder.onPress;
            spContentHolder.tabEnabled = false;
            spContentHolder.tabChildren = true;
            spContentHolder.useHandCursor = false;
            __scrollDrag = false;
        } // end else if
        //return (this.scrollDrag());
        null;
    } // End of the function
    function init(Void)
    {
        super.init();
        tabEnabled = true;
        keyDown = _onKeyDown;
    } // End of the function
    function createChildren(Void)
    {
        super.createChildren();
        mask_mc._visible = false;
        initializing = false;
        if (__scrollContent != undefined && __scrollContent != "")
        {
            this.__set__contentPath(__scrollContent);
        } // end if
    } // End of the function
    function size(Void)
    {
        super.size();
        this.setScrollProperties(spContentHolder._width, 1, spContentHolder._height, 1);
        hPosition = Math.min(hPosition, this.__get__maxHPosition());
        vPosition = Math.min(vPosition, this.__get__maxVPosition());
    } // End of the function
    function setScrollProperties(columnCount, columnWidth, rowCount, rowHeight)
    {
        super.setScrollProperties(columnCount, columnWidth, rowCount, rowHeight);
        hScroller.__set__lineScrollSize(__hLineScrollSize);
        hScroller.__set__pageScrollSize(__hPageScrollSize);
        vScroller.__set__lineScrollSize(__vLineScrollSize);
        vScroller.__set__pageScrollSize(__vPageScrollSize);
    } // End of the function
    function onScroll(scrollEvent)
    {
        spContentHolder._x = -__hPosition;
        spContentHolder._y = -__vPosition;
        super.onScroll(scrollEvent);
    } // End of the function
    function childLoaded(obj)
    {
        super.childLoaded(obj);
        this.onComplete();
    } // End of the function
    function onComplete(Void)
    {
        this.setScrollProperties(spContentHolder._width, 1, spContentHolder._height, 1);
        hPosition = 0;
        vPosition = 0;
        this.__set__scrollDrag(__scrollDrag);
        this.invalidate();
    } // End of the function
    function startDragLoop(Void)
    {
        spContentHolder.lastX = spContentHolder._xmouse;
        spContentHolder.lastY = spContentHolder._ymouse;
        spContentHolder.onMouseMove = function ()
        {
            var _loc5 = lastX - _xmouse;
            var _loc4 = lastY - _ymouse;
            _loc5 = _loc5 + _parent.hPosition;
            _loc4 = _loc4 + _parent.vPosition;
            var _loc3 = _parent.getViewMetrics();
            var _loc7 = _parent.__height - _loc3.top - _loc3.bottom;
            var _loc6 = _parent.__width - _loc3.left - _loc3.right;
            _parent.__hPosition = Math.max(0, Math.min(_loc5, _width - _loc6));
            _parent.__vPosition = Math.max(0, Math.min(_loc4, _height - _loc7));
            _parent.hScroller.scrollPosition = _parent.__hPosition;
            _x = -_parent.hPosition;
            _parent.vScroller.scrollPosition = _parent.__vPosition;
            _y = -_parent.vPosition;
            super.dispatchEvent({type: "scroll"});
        };
    } // End of the function
    function dispatchEvent(o)
    {
        o.target = this;
        _total = o.total;
        _loaded = o.current;
        super.dispatchEvent(o);
    } // End of the function
    function refreshPane(Void)
    {
        this.__set__contentPath(__scrollContent);
    } // End of the function
    function _onKeyDown(e)
    {
        if (hScroller != undefined && __hPosition <= hScroller.maxPos && __hPosition >= hScroller.minPos)
        {
            if (e.code == 37)
            {
                hPosition = hPosition - hLineScrollSize;
            }
            else if (e.code == 39)
            {
                hPosition = hPosition + hLineScrollSize;
            } // end if
        } // end else if
        if (vScroller != undefined && __vPosition <= vScroller.maxPos && __vPosition >= vScroller.minPos)
        {
            if (e.code == 33)
            {
                vPosition = vPosition - vPageScrollSize;
            }
            else if (e.code == 34)
            {
                vPosition = vPosition + vPageScrollSize;
            } // end else if
            if (e.code == 40)
            {
                vPosition = vPosition + vLineScrollSize;
            }
            else if (e.code == 38)
            {
                vPosition = vPosition - vLineScrollSize;
            } // end if
        } // end else if
        if (e.code == 36)
        {
            vPosition = vScroller.minPos;
        }
        else if (e.code == 35)
        {
            vPosition = vScroller.maxPos;
        } // end else if
    } // End of the function
    static var symbolName = "ScrollPane";
    static var symbolOwner = mx.containers.ScrollPane;
    var className = "ScrollPane";
    static var version = "2.0.2.126";
    var __hScrollPolicy = "auto";
    var __scrollDrag = false;
    var __vLineScrollSize = 5;
    var __hLineScrollSize = 5;
    var __vPageScrollSize = 20;
    var __hPageScrollSize = 20;
    var clipParameters = {contentPath: 1, scrollDrag: 1, hScrollPolicy: 1, vScrollPolicy: 1, vLineScrollSize: 1, hLineScrollSize: 1, vPageScrollSize: 1, hPageScrollSize: 1};
    static var mergedClipParameters = mx.core.UIObject.mergeClipParameters(mx.containers.ScrollPane.prototype.clipParameters, mx.core.ScrollView.prototype.clipParameters);
    var initializing = true;
} // End of Class
